setwd("<your directory or folder path>")
df1 <- read.csv("20190927 Example 14.1 Two-Sample Test.csv")
#
# df1 has the following columns:
#
# Y
# Group
#
# Note:  Y was simulated so that:
# Group A mu = 10.00, Group A sigma = 1.65
# Group B mu = 10.40, Group B sigma = 1.80
#
# n = 50 in both groups
#
# 
#
library(dplyr) #has some nice functions for computing groupwise
#               descriptive statistics
#
rank.comp <- rank(df1$Y)#this computes the rankls of all the data, 
#                        ordered from smallest to largest without 
#                        regard to Group
#
df2 <- cbind(df1,rank.comp)#combines the Rank column, rank.comp, with the Group variable
attach(df2)
group_by(df2,Group)%>%
summarise(count=n(),mean=mean(Y),sd=sd(Y))
#
t.test(Y ~ Group,alternative=c("two.sided"),var.equal=TRUE)
t.test(rank.comp ~ Group,alternative=c("two.sided"),var.equal=TRUE)
wilcox.test(Y ~ Group,alternative=c("two.sided"),correct=FALSE)

